//lsqrsolver13.sce
 // formula: Y=a*exp(-((X-b)/c)^2)
 // input data
 //
 Y= [64.940,91.614,91.691,113.741,456.187,458.556,653.687];
 Y=Y';
 n = length(Y) ;      // number of actual data point
 X=(1:n)';
//
  function e=f1(p, m)
    a=p(1);b=p(2),c=p(3),
    e=Y-a*exp(-((X-b)/c)^2);
  endfunction
  [p,v]=lsqrsolve([2;1;2],f1,size(X,1));
   p
 //
 XX=(1:20)';
 Y2=p(1)*exp(-((XX-p(2))/p(3))^2);
 Y3=cumsum(Y2);
 //
 // plot
 //
 plot2d(X,Y,style=-3)
 plot2d(XX,Y2,style=2)
 plot2d(XX,Y3,style=2)
 // results
      mprintf('Parameters of Model\n\n' );
      mprintf('  a :  %7.4f \n', p(1));
      mprintf('  b :  %7.4f \n', p(2));
      mprintf('  c :  %7.4f \n', p(3));
      mprintf('\n\n' );
 //
 mprintf(' TIME    Actual    Estimated   Cumulative \n');
   for I=1:n;
      mprintf('%3d  %10.3f  %10.3f  %10.3f \n', I, Y(I),Y2(I),Y3(I)); 
   end
   nn=length(Y2);
  for J=n+1:nn;
      Y(J)=0;
      mprintf('%3d  %10.3f  %10.3f  %10.3f \n', J, Y(J),Y2(J),Y3(J)); 
   end
